local t = Def.ActorFrame {};
local song = GAMESTATE:GetCurrentSong();
local sname = song:GetDisplayMainTitle();
local ssname = song:GetDisplaySubTitle();
if ssname == "" then ssname = nil end
local sartist = song:GetDisplayArtist();
local jkt = song:GetJacketPath();
local bn = song:GetBannerPath();
local cx = SCREEN_CENTER_X;
local cy = SCREEN_CENTER_Y;
if song:HasJacket() then
	t[#t+1] = LoadActor("../_jacketframe")..{
		InitCommand=function(self) self:Center():scaletofit(cx-152.5,cy-80,cx+152.5,cy+80):addy(-350):diffusealpha(1) end;
		OnCommand=function(self) self:sleep(2.8):accelerate(0.7):addy(350):queuecommand("Vibe1") end;
		Vibe1Command=function(self) self:vibrate():effectmagnitude(15,15,15):sleep(0.2):queuecommand("Vibe2") end;
		Vibe2Command=function(self) self:vibrate():effectmagnitude(12,12,12):sleep(0.2):queuecommand("Vibe3") end;
		Vibe3Command=function(self) self:vibrate():effectmagnitude(9,9,9):sleep(0.2):queuecommand("Vibe4") end;
		Vibe4Command=function(self) self:vibrate():effectmagnitude(6,6,6):sleep(0.2):queuecommand("Vibe5") end;
		Vibe5Command=function(self) self:vibrate():effectmagnitude(3,3,3):sleep(0.2):queuecommand("Vibe6") end;
		Vibe6Command=function(self) self:stopeffect() end;
	};
	t[#t+1] = LoadActor(jkt)..{
		InitCommand=function(self) self:Center():diffusealpha(0) end;
		OnCommand=function(self) self:sleep(3.5):linear(0.1):diffusealpha(1):scaletofit(cx-79,cy-79,cx+79,cy+79):queuecommand("Vibe1") end;
		Vibe1Command=function(self) self:vibrate():effectmagnitude(15,15,15):sleep(0.2):queuecommand("Vibe2") end;
		Vibe2Command=function(self) self:vibrate():effectmagnitude(12,12,12):sleep(0.2):queuecommand("Vibe3") end;
		Vibe3Command=function(self) self:vibrate():effectmagnitude(9,9,9):sleep(0.2):queuecommand("Vibe4") end;
		Vibe4Command=function(self) self:vibrate():effectmagnitude(6,6,6):sleep(0.2):queuecommand("Vibe5") end;
		Vibe5Command=function(self) self:vibrate():effectmagnitude(3,3,3):sleep(0.2):queuecommand("Vibe6") end;
		Vibe6Command=function(self) self:stopeffect() end;
	};
elseif song:HasBanner() then
	t[#t+1] = LoadActor("../_commonbannerframe")..{
		InitCommand=function(self) self:Center():scaletofit(cx-152.5,cy-80,cx+152.5,cy+80):addy(-300):diffusealpha(1) end;
		OnCommand=function(self) self:sleep(2.8):accelerate(0.7):addy(300):queuecommand("Vibe1") end;
		Vibe1Command=function(self) self:vibrate():effectmagnitude(15,15,15):sleep(0.2):queuecommand("Vibe2") end;
		Vibe2Command=function(self) self:vibrate():effectmagnitude(12,12,12):sleep(0.2):queuecommand("Vibe3") end;
		Vibe3Command=function(self) self:vibrate():effectmagnitude(9,9,9):sleep(0.2):queuecommand("Vibe4") end;
		Vibe4Command=function(self) self:vibrate():effectmagnitude(6,6,6):sleep(0.2):queuecommand("Vibe5") end;
		Vibe5Command=function(self) self:vibrate():effectmagnitude(3,3,3):sleep(0.2):queuecommand("Vibe6") end;
		Vibe6Command=function(self) self:stopeffect() end;
	};
	t[#t+1] = LoadActor(bn)..{
		InitCommand=function(self) self:Center():diffusealpha(0) end;
		OnCommand=function(self) -- check banner size, resize accordingly
			local w = self:GetWidth();
			local h = self:GetHeight();
			if w == 256 and h == 80 then -- classic common size
				self:sleep(3.5):diffusealpha(1):scaletofit(cx-150,cy-150,cx+150,cy+150):queuecommand("Vibe1") end;
			if w == 418 and h == 164 then -- modern common size
				self:sleep(3.5):diffusealpha(1):scaletofit(cx-150,cy-150,cx+150,cy+150):zoomy(0.55):queuecommand("Vibe1") end;
		end;
		Vibe1Command=function(self) self:vibrate():effectmagnitude(15,15,15):sleep(0.2):queuecommand("Vibe2") end;
		Vibe2Command=function(self) self:vibrate():effectmagnitude(12,12,12):sleep(0.2):queuecommand("Vibe3") end;
		Vibe3Command=function(self) self:vibrate():effectmagnitude(9,9,9):sleep(0.2):queuecommand("Vibe4") end;
		Vibe4Command=function(self) self:vibrate():effectmagnitude(6,6,6):sleep(0.2):queuecommand("Vibe5") end;
		Vibe5Command=function(self) self:vibrate():effectmagnitude(3,3,3):sleep(0.2):queuecommand("Vibe6") end;
		Vibe6Command=function(self) self:stopeffect() end;
	};
else
	t[#t+1] = LoadActor("../_jacketframe")..{
		InitCommand=function(self) self:Center():scaletofit(cx-152.5,cy-80,cx+152.5,cy+80):addy(-350):diffusealpha(1) end;
		OnCommand=function(self) self:sleep(2.8):accelerate(0.7):addy(350):queuecommand("Vibe1") end;
		Vibe1Command=function(self) self:vibrate():effectmagnitude(15,15,15):sleep(0.2):queuecommand("Vibe2") end;
		Vibe2Command=function(self) self:vibrate():effectmagnitude(12,12,12):sleep(0.2):queuecommand("Vibe3") end;
		Vibe3Command=function(self) self:vibrate():effectmagnitude(9,9,9):sleep(0.2):queuecommand("Vibe4") end;
		Vibe4Command=function(self) self:vibrate():effectmagnitude(6,6,6):sleep(0.2):queuecommand("Vibe5") end;
		Vibe5Command=function(self) self:vibrate():effectmagnitude(3,3,3):sleep(0.2):queuecommand("Vibe6") end;
		Vibe6Command=function(self) self:stopeffect() end;
	};
	t[#t+1] = LoadActor(THEME:GetPathG("", "Common fallback jacket"))..{
		InitCommand=function(self) self:Center():addy(-25):diffusealpha(0) end;
		OnCommand=function(self) self:sleep(3.5):linear(0.1):diffusealpha(1):scaletofit(cx-79,cy-79,cx+79,cy+79):queuecommand("Vibe1") end;
		Vibe1Command=function(self) self:vibrate():effectmagnitude(15,15,15):sleep(0.2):queuecommand("Vibe2") end;
		Vibe2Command=function(self) self:vibrate():effectmagnitude(12,12,12):sleep(0.2):queuecommand("Vibe3") end;
		Vibe3Command=function(self) self:vibrate():effectmagnitude(9,9,9):sleep(0.2):queuecommand("Vibe4") end;
		Vibe4Command=function(self) self:vibrate():effectmagnitude(6,6,6):sleep(0.2):queuecommand("Vibe5") end;
		Vibe5Command=function(self) self:vibrate():effectmagnitude(3,3,3):sleep(0.2):queuecommand("Vibe6") end;
		Vibe6Command=function(self) self:stopeffect() end;
	};
end
t[#t+1] = LoadActor("_bossattack")..{
	InitCommand=function(self) self:Center():zoom(0.6):addy(-150):diffusealpha(0) end;
	OnCommand=function(self) self:sleep(3.5):diffusealpha(1):queuecommand("Vibe1") end;
		Vibe1Command=function(self) self:vibrate():effectmagnitude(15,15,15):sleep(0.2):queuecommand("Vibe2") end;
		Vibe2Command=function(self) self:vibrate():effectmagnitude(12,12,12):sleep(0.2):queuecommand("Vibe3") end;
		Vibe3Command=function(self) self:vibrate():effectmagnitude(9,9,9):sleep(0.2):queuecommand("Vibe4") end;
		Vibe4Command=function(self) self:vibrate():effectmagnitude(6,6,6):sleep(0.2):queuecommand("Vibe5") end;
		Vibe5Command=function(self) self:vibrate():effectmagnitude(3,3,3):sleep(0.2):queuecommand("Vibe6") end;
		Vibe6Command=function(self) self:stopeffect() end;
};
t[#t+1] = LoadActor(THEME:GetPathG("ScreenStageInformation", "Stage extra1"))..{
	InitCommand=function(self) self:Center():addy(175):diffusealpha(0):zoom(0.8) end;
	OnCommand=function(self) self:sleep(3.5):diffusealpha(1):zoom(0.6):queuecommand("Vibe1") end;
		Vibe1Command=function(self) self:vibrate():effectmagnitude(15,15,15):sleep(0.2):queuecommand("Vibe2") end;
		Vibe2Command=function(self) self:vibrate():effectmagnitude(12,12,12):sleep(0.2):queuecommand("Vibe3") end;
		Vibe3Command=function(self) self:vibrate():effectmagnitude(9,9,9):sleep(0.2):queuecommand("Vibe4") end;
		Vibe4Command=function(self) self:vibrate():effectmagnitude(6,6,6):sleep(0.2):queuecommand("Vibe5") end;
		Vibe5Command=function(self) self:vibrate():effectmagnitude(3,3,3):sleep(0.2):queuecommand("Vibe6") end;
		Vibe6Command=function(self) self:stopeffect() end;
};
t[#t+1] = LoadActor("_exflavor")..{
	InitCommand=function(self) self:Center():diffuse(color("#FF0000")):diffusealpha(0):zoom(0.75) end;
	OnCommand=function(self) self:sleep(0.7):queuecommand("Blink"):queuecommand("Blink"):queuecommand("Blink"):queuecommand("Blink") end;
	BlinkCommand=function(self) self:linear(0.2):diffusealpha(1):sleep(0.2):linear(0.2):diffusealpha(0) end;
};
t[#t+1] = LoadFont("_pixellari 32px")..{ --song title
	InitCommand=function(self) self:Center():addy(110):diffusealpha(0) end;
	OnCommand=function(self)
		if ssname then -- has sub title
			self:settextf("%s\n\n%s",sname,ssname)
			self:zoom(0.7)
		elseif ssname == "" or ssname == nil then -- no sub title
			self:settextf("%s",sname)
			self:zoom(1)
		end
		self:sleep(3.5):diffusealpha(1):queuecommand("Vibe1") end;
		Vibe1Command=function(self) self:vibrate():effectmagnitude(15,15,15):sleep(0.2):queuecommand("Vibe2") end;
		Vibe2Command=function(self) self:vibrate():effectmagnitude(12,12,12):sleep(0.2):queuecommand("Vibe3") end;
		Vibe3Command=function(self) self:vibrate():effectmagnitude(9,9,9):sleep(0.2):queuecommand("Vibe4") end;
		Vibe4Command=function(self) self:vibrate():effectmagnitude(6,6,6):sleep(0.2):queuecommand("Vibe5") end;
		Vibe5Command=function(self) self:vibrate():effectmagnitude(3,3,3):sleep(0.2):queuecommand("Vibe6") end;
		Vibe6Command=function(self) self:stopeffect() end;
};
t[#t+1] = LoadFont("_pixellari 32px")..{ -- song artist
	InitCommand=function(self) self:Center():addy(125):diffusealpha(0) end;
	OnCommand=function(self)
		if ssname then -- has sub title
			self:addy(20):zoom(0.9)
		elseif ssname == "" or ssname == nil then -- no sub title
			self:addy(10):zoom(1)
		end
		self:settext(sartist):sleep(3.5):diffusealpha(1):queuecommand("Vibe1") end;
		Vibe1Command=function(self) self:vibrate():effectmagnitude(15,15,15):sleep(0.2):queuecommand("Vibe2") end;
		Vibe2Command=function(self) self:vibrate():effectmagnitude(12,12,12):sleep(0.2):queuecommand("Vibe3") end;
		Vibe3Command=function(self) self:vibrate():effectmagnitude(9,9,9):sleep(0.2):queuecommand("Vibe4") end;
		Vibe4Command=function(self) self:vibrate():effectmagnitude(6,6,6):sleep(0.2):queuecommand("Vibe5") end;
		Vibe5Command=function(self) self:vibrate():effectmagnitude(3,3,3):sleep(0.2):queuecommand("Vibe6") end;
		Vibe6Command=function(self) self:stopeffect() end;
};
t[#t+1] = Def.Quad {
	InitCommand=function(self) self:Center():FullScreen():diffuse(color("#FFFFFF")):diffusealpha(0)	end;
	OnCommand=function(self) self:sleep(3.5):diffusealpha(1):linear(0.5):diffusealpha(0) end;
};
t[#t+1] = LoadActor(THEME:GetPathS("", "shortwarning.ogg"))..{
	OnCommand=function(self) self:sleep(0.3):queuecommand("Play"):sleep(1.5):queuecommand("Play") end;
	PlayCommand=function(self) self:play() end;
};
t[#t+1] = LoadActor("_extrasound")..{
	OnCommand=function(self) self:queuecommand("Play") end;
	PlayCommand=function(self) self:play() end;
};
t[#t+1] = LoadActor("_exshock")..{
	OnCommand=function(self) self:sleep(3.4):queuecommand("Play") end;
	PlayCommand=function(self) self:play() end;
};
return t